<?php

namespace App\Mail\Resident;

use App\Models\Bill;
use App\Models\Society;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class BillGenerated extends Mailable
{
    use Queueable, SerializesModels;

    public Bill $bill;
    public User $resident;
    public Society $society;

    /**
     * Create a new message instance.
     */
    public function __construct(Bill $bill, User $resident, Society $society)
    {
        $this->bill = $bill;
        $this->resident = $resident;
        $this->society = $society;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: "New Bill Generated - {$this->bill->bill_no}",
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.resident.bill-generated',
            with: [
                'bill' => $this->bill,
                'resident' => $this->resident,
                'society' => $this->society,
                'appUrl' => url('/'),
            ],
        );
    }

    /**
     * Get the attachments for the message.
     */
    public function attachments(): array
    {
        return [];
    }
}
