<?php

namespace App\Mail\Resident;

use App\Models\Bill;
use App\Models\Society;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class BillDueReminder extends Mailable
{
    use Queueable, SerializesModels;

    public Bill $bill;
    public User $resident;
    public Society $society;
    public int $daysUntilDue;

    /**
     * Create a new message instance.
     */
    public function __construct(Bill $bill, User $resident, Society $society, int $daysUntilDue)
    {
        $this->bill = $bill;
        $this->resident = $resident;
        $this->society = $society;
        $this->daysUntilDue = $daysUntilDue;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        $subject = $this->daysUntilDue === 0 
            ? "⚠️ Bill Due Today - {$this->bill->bill_no}"
            : "📅 Bill Due in {$this->daysUntilDue} Days - {$this->bill->bill_no}";

        return new Envelope(subject: $subject);
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.resident.bill-due-reminder',
            with: [
                'bill' => $this->bill,
                'resident' => $this->resident,
                'society' => $this->society,
                'daysUntilDue' => $this->daysUntilDue,
                'appUrl' => url('/'),
            ],
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
