<?php

namespace App\Http\Traits;

trait HasFlashMessages
{
    /**
     * Flash a success message
     */
    protected function flashSuccess(string $message): void
    {
        session()->flash('success', $message);
    }

    /**
     * Flash an error message
     */
    protected function flashError(string $message): void
    {
        session()->flash('error', $message);
    }

    /**
     * Flash a warning message
     */
    protected function flashWarning(string $message): void
    {
        session()->flash('warning', $message);
    }

    /**
     * Flash an info message
     */
    protected function flashInfo(string $message): void
    {
        session()->flash('info', $message);
    }

    /**
     * Redirect back with success message
     */
    protected function redirectWithSuccess(string $message)
    {
        return redirect()->back()->with('success', $message);
    }

    /**
     * Redirect back with error message
     */
    protected function redirectWithError(string $message)
    {
        return redirect()->back()->with('error', $message);
    }

    /**
     * Redirect back with warning message
     */
    protected function redirectWithWarning(string $message)
    {
        return redirect()->back()->with('warning', $message);
    }

    /**
     * Redirect back with info message
     */
    protected function redirectWithInfo(string $message)
    {
        return redirect()->back()->with('info', $message);
    }

    /**
     * Redirect to route with success message
     */
    protected function redirectToWithSuccess(string $route, string $message, array $parameters = [])
    {
        return redirect()->route($route, $parameters)->with('success', $message);
    }

    /**
     * Redirect to route with error message
     */
    protected function redirectToWithError(string $route, string $message, array $parameters = [])
    {
        return redirect()->route($route, $parameters)->with('error', $message);
    }
}
