<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class VisitorResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'phone' => $this->phone,
            'vehicle_number' => $this->vehicle_number,
            'type' => $this->type,
            'purpose' => $this->purpose,
            'status' => $this->status,
            'gatepass_code' => $this->gatepass_code,
            'entry_time' => $this->entry_time instanceof \DateTime ? $this->entry_time->format('Y-m-d H:i:s') : $this->entry_time,
            'exit_time' => $this->exit_time instanceof \DateTime ? $this->exit_time->format('Y-m-d H:i:s') : $this->exit_time,
            'resident' => [
                'id' => $this->user_id,
                'name' => $this->user?->name,
                'unit' => $this->user?->unit?->unit_no,
            ],
            'created_at' => $this->created_at->toIso8601String(),
        ];
    }
}
