<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProfileResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'phone' => $this->phone,
            'role' => $this->role_display,
            'profile_photo_url' => $this->profile_photo_url, // Assuming standard Laravel Fortify/Jetstream field
            'society' => [
                'id' => $this->society_id,
                'name' => $this->society->name,
                'code' => $this->society->code,
                'logo' => $this->society->logo,
            ],
            'unit' => $this->unit ? [
                'id' => $this->unit_id,
                'unit_no' => $this->unit->unit_no,
                'building' => $this->unit->building ? $this->unit->building->name : null,
            ] : null,
        ];
    }
}
