<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MaintenanceTicketResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'ticket_no' => $this->ticket_no,
            'title' => $this->title,
            'description' => $this->description,
            'priority' => $this->priority,
            'status' => $this->status,
            'resolution_notes' => $this->resolution_notes,
            'created_at' => $this->created_at->toIso8601String(),
            'assigned_at' => $this->assigned_at ? $this->assigned_at->toIso8601String() : null,
            'resolved_at' => $this->resolved_at ? $this->resolved_at->toIso8601String() : null,
            'resident' => [
                'id' => $this->user_id,
                'name' => $this->user->name ?? null,
                'unit' => $this->user->unit->unit_no ?? null,
            ],
        ];
    }
}
