<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CommunityPostResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'content' => $this->content,
            'image' => $this->image,
            'media_type' => $this->media_type,
            'media_urls' => $this->media_urls,
            'is_pinned' => $this->is_pinned,
            'created_at' => $this->created_at->toIso8601String(),

            'user' => [
                'id' => $this->user_id,
                'name' => $this->user->name,
                'photo' => $this->user->profile_photo_url,
                'role' => $this->user->role_display,
                'unit' => $this->user->unit ? $this->user->unit->unit_no : null,
            ],
            'is_liked' => $this->is_liked ?? false,
            'likes_count' => $this->likes_count ?? 0,
            'comments_count' => $this->comments_count ?? 0,
        ];
    }
}
