<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AnnouncementResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'content' => $this->content,
            'type' => $this->type,
            'priority' => $this->priority,
            'start_date' => $this->start_date ? $this->start_date->toIso8601String() : ($this->created_at->toIso8601String()),
            'end_date' => $this->end_date ? $this->end_date->toIso8601String() : null,
            'require_acknowledgement' => $this->require_acknowledgement,
            'is_acknowledged' => $this->when($request->user(), function () use ($request) {
                return $this->acknowledgements()->where('user_id', $request->user()->id)->exists();
            }, false),
            'attachments' => $this->attachments ?? [],
            'created_at' => $this->created_at->toIso8601String(),
            'created_by' => $this->createdBy ? $this->createdBy->name : 'Admin',
        ];
    }
}
