<?php

namespace App\Http\Requests\SuperAdmin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateSubscriptionPlanRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $planId = $this->route('subscription_plan');

        return [
            'name' => ['required', 'string', 'max:255', Rule::unique('subscription_plans', 'name')->ignore($planId)],
            'display_name' => ['required', 'string', 'max:255'],
            'description' => ['nullable', 'string'],
            'monthly_price' => ['required', 'numeric', 'min:0'],
            'quarterly_price' => ['nullable', 'numeric', 'min:0'],
            'annual_price' => ['nullable', 'numeric', 'min:0'],
            'max_users' => ['required', 'integer', 'min:1'],
            'max_units' => ['required', 'integer', 'min:1'],
            'max_buildings' => ['required', 'integer', 'min:1'],
            'storage_gb' => ['required', 'integer', 'min:0'],
            'sms_enabled' => ['boolean'],
            'whatsapp_enabled' => ['boolean'],
            'email_enabled' => ['boolean'],
            'fcm_enabled' => ['boolean'],
            'advanced_reports' => ['boolean'],
            'api_access' => ['boolean'],
            'custom_branding' => ['boolean'],
            'priority_support' => ['boolean'],
            'white_label' => ['boolean'],
            'is_active' => ['boolean'],
            'sort_order' => ['nullable', 'integer', 'min:0'],
            'validity_days' => ['nullable', 'integer', 'min:1'],
        ];
    }
}
