<?php

namespace App\Http\Requests\SuperAdmin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateSocietyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $societyId = $this->route('society');

        return [
            'name' => ['required', 'string', 'max:255'],
            'registration_no' => ['required', 'string', 'max:255', Rule::unique('societies', 'registration_no')->ignore($societyId)],
            'address' => ['required', 'string'],
            'city' => ['required', 'string', 'max:255'],
            'state' => ['required', 'string', 'max:50'],
            'pincode' => ['required', 'string', 'max:10'],
            'platform_user_id' => ['nullable', 'exists:users,id'],
            'platform_fee_amount' => ['nullable', 'numeric', 'min:0'],
            'platform_fee_frequency' => ['nullable', 'in:monthly,quarterly,annual'],
            'status' => ['required', 'in:pending,active,suspended,inactive'],
            'logo' => ['nullable', 'string', 'max:255'],
            'gst_no' => ['nullable', 'string', 'max:255'],
            'pan_no' => ['nullable', 'string', 'max:255'],
            'rules' => ['nullable', 'string'],
            'code' => ['nullable', 'string', 'max:255', Rule::unique('societies', 'code')->ignore($societyId)],
            'phone' => ['nullable', 'string', 'max:20'],
            'email' => ['nullable', 'email', 'max:255'],
        ];
    }
}
