<?php

namespace App\Http\Requests\SuperAdmin;

use Illuminate\Foundation\Http\FormRequest;

class StoreSocietyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'registration_no' => ['required', 'string', 'max:255', 'unique:societies,registration_no'],
            'address' => ['required', 'string'],
            'city' => ['required', 'string', 'max:255'],
            'state' => ['required', 'string', 'max:50'],
            'pincode' => ['required', 'string', 'max:10'],
            // Admin creation fields
            'admin.name' => ['required', 'string', 'max:255'],
            'admin.email' => ['required', 'email', 'max:255', 'unique:users,email'],
            'admin.phone' => ['required', 'string', 'max:20', 'unique:users,phone'],
            'admin.password' => ['required', 'string', 'min:8'],
            'status' => ['required', 'in:pending,active,suspended,inactive'],
            'logo' => ['nullable', 'string', 'max:255'],
            'gst_no' => ['nullable', 'string', 'max:255'],
            'pan_no' => ['nullable', 'string', 'max:255'],
            'rules' => ['nullable', 'string'],
            'code' => ['nullable', 'string', 'max:255', 'unique:societies,code'],
            'phone' => ['nullable', 'string', 'max:20'],
            'email' => ['nullable', 'email', 'max:255'],

            // Subscription fields
            'subscription.plan_id' => ['required', 'exists:subscription_plans,id'],
            'subscription.billing_cycle' => ['required', 'in:monthly,quarterly,annual'],
            'subscription.status' => ['required', 'in:active,trial,expired,cancelled,suspended'],
            'subscription.start_date' => ['required', 'date'],
            'subscription.end_date' => ['nullable', 'date', 'after:subscription.start_date'],

            // Settings fields - all optional, only enable/disable flags are used
            'settings.razorpay_enabled' => ['nullable', 'boolean'],
            'settings.stripe_enabled' => ['nullable', 'boolean'],
            'settings.payu_enabled' => ['nullable', 'boolean'],
            'settings.cashfree_enabled' => ['nullable', 'boolean'],
            'settings.email_enabled' => ['nullable', 'boolean'],
            'settings.sms_enabled' => ['nullable', 'boolean'],
            'settings.whatsapp_enabled' => ['nullable', 'boolean'],
            'settings.fcm_enabled' => ['nullable', 'boolean'],
            'settings.enable_visitor_management' => ['nullable', 'boolean'],
            'settings.enable_maintenance_tickets' => ['nullable', 'boolean'],
            'settings.enable_complaints' => ['nullable', 'boolean'],
            'settings.enable_events' => ['nullable', 'boolean'],
            'settings.enable_documents' => ['nullable', 'boolean'],
            'settings.enable_directory' => ['nullable', 'boolean'],
            'settings.enable_notices' => ['nullable', 'boolean'],
            'settings.enable_polls' => ['nullable', 'boolean'],
            'settings.enable_marketplace' => ['nullable', 'boolean'],
            'settings.notify_bill_generated' => ['nullable', 'boolean'],
            'settings.notify_payment_received' => ['nullable', 'boolean'],
            'settings.notify_visitor_arrival' => ['nullable', 'boolean'],
            'settings.notify_maintenance_request' => ['nullable', 'boolean'],
            'settings.notify_announcement' => ['nullable', 'boolean'],
            'settings.require_otp_for_login' => ['nullable', 'boolean'],
            'settings.require_otp_for_payment' => ['nullable', 'boolean'],
            'settings.enable_2fa' => ['nullable', 'boolean'],
            'settings.timezone' => ['nullable', 'string', 'max:100'],
            'settings.currency' => ['nullable', 'string', 'max:10'],
            'settings.date_format' => ['nullable', 'string', 'max:20'],
            'settings.time_format' => ['nullable', 'string', 'max:10'],
            'settings.language' => ['nullable', 'string', 'max:10'],
            'settings.session_timeout_minutes' => ['nullable', 'integer', 'min:1'],
        ];
    }
}
