<?php

namespace App\Http\Requests\SocietyAdmin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateVisitorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $societyId = $this->route('society')->id;
        $visitorId = $this->route('visitor')->id;

        return [
            'user_id' => ['nullable', 'exists:users,id', Rule::exists('users', 'id')->where('society_id', $societyId)],
            'name' => ['required', 'string', 'max:255'],
            'phone' => ['required', 'string', 'max:20'],
            'email' => ['nullable', 'email', 'max:255'],
            'type' => ['required', 'in:guest,delivery,service,staff,cab'],
            'purpose' => ['required', 'string', 'max:255'],
            'no_of_visitors' => ['nullable', 'integer', 'min:1', 'max:50'],
            'vehicle_number' => ['nullable', 'string', 'max:50'],
            'gatepass_code' => [
                'nullable',
                'string',
                'max:8',
                Rule::unique('visitors', 'gatepass_code')->ignore($visitorId),
            ],
            'entry_time' => ['nullable', 'date'],
            'status' => ['nullable', 'in:pending,approved,rejected,checked_in,checked_out'],
            'notes' => ['nullable', 'string'],
        ];
    }
}
