<?php

namespace App\Http\Requests\SocietyAdmin;

use Illuminate\Foundation\Http\FormRequest;

class UpdateVendorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $society = $this->route('society');
        $societyId = is_object($society) ? $society->id : (int) $society;
        $vendor = $this->route('vendor');
        $vendorId = is_object($vendor) ? $vendor->id : (int) $vendor;

        return [
            'name' => ['required', 'string', 'max:255'],
            'company_name' => ['nullable', 'string', 'max:255'],
            'email' => [
                'nullable',
                'email',
                'max:255',
                'unique:users,email,'.$vendorId.',id,society_id,'.$societyId,
            ],
            'phone' => [
                'required',
                'string',
                'max:20',
                'unique:users,phone,'.$vendorId.',id,society_id,'.$societyId,
            ],
            'gst_number' => ['nullable', 'string', 'max:50'],
            'address' => ['nullable', 'string', 'max:1000'],
            'status' => ['required', 'in:active,inactive'],
        ];
    }
}
