<?php

namespace App\Http\Requests\SocietyAdmin;

use Illuminate\Foundation\Http\FormRequest;

class UpdateSocietySettingsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            // Society Details
            'name' => ['required', 'string', 'max:255'],
            'code' => ['nullable', 'string', 'max:20', 'unique:societies,code,' . $this->route('society')->id],
            'registration_no' => ['nullable', 'string', 'max:50'],
            'address' => ['required', 'string', 'max:500'],
            'city' => ['required', 'string', 'max:100'],
            'state' => ['required', 'string', 'max:100'],
            'pincode' => ['required', 'string', 'max:20'],
            'phone' => ['required', 'string', 'max:20'],
            'email' => ['required', 'email', 'max:255'],
            'gst_no' => ['nullable', 'string', 'max:20'],
            'pan_no' => ['nullable', 'string', 'max:20'],
            'rules' => ['nullable', 'array'],

            // Payment Gateway
            'payment_gateway' => ['nullable', 'in:razorpay,stripe,payu,cashfree,none'],
            'razorpay_key_id' => ['nullable', 'string', 'max:255'],
            'razorpay_key_secret' => ['nullable', 'string', 'max:255'],
            'razorpay_webhook_secret' => ['nullable', 'string', 'max:255'],
            'razorpay_enabled' => ['nullable', 'boolean'],
            'stripe_public_key' => ['nullable', 'string', 'max:255'],
            'stripe_secret_key' => ['nullable', 'string', 'max:255'],
            'stripe_enabled' => ['nullable', 'boolean'],
            'payu_merchant_key' => ['nullable', 'string', 'max:255'],
            'payu_merchant_salt' => ['nullable', 'string', 'max:255'],
            'payu_enabled' => ['nullable', 'boolean'],
            'cashfree_app_id' => ['nullable', 'string', 'max:255'],
            'cashfree_secret_key' => ['nullable', 'string', 'max:255'],
            'cashfree_enabled' => ['nullable', 'boolean'],

            // Email Settings
            'email_enabled' => ['nullable', 'boolean'],
            'email_provider' => ['nullable', 'in:smtp,sendgrid,mailgun'],
            'smtp_host' => ['nullable', 'string', 'max:255'],
            'smtp_port' => ['nullable', 'integer', 'min:1', 'max:65535'],
            'smtp_username' => ['nullable', 'string', 'max:255'],
            'smtp_password' => ['nullable', 'string', 'max:255'],
            'smtp_encryption' => ['nullable', 'in:tls,ssl'],
            'from_email' => ['nullable', 'email', 'max:255'],
            'from_name' => ['nullable', 'string', 'max:255'],

            // SMS Settings
            'sms_enabled' => ['nullable', 'boolean'],
            'sms_provider' => ['nullable', 'string', 'max:255'],
            'sms_api_key' => ['nullable', 'string', 'max:255'],
            'sms_sender_id' => ['nullable', 'string', 'max:255'],
            'sms_username' => ['nullable', 'string', 'max:255'],
            'sms_password' => ['nullable', 'string', 'max:255'],

            // WhatsApp Settings
            'whatsapp_enabled' => ['nullable', 'boolean'],
            'whatsapp_provider' => ['nullable', 'string', 'max:255'],
            'whatsapp_api_key' => ['nullable', 'string', 'max:255'],
            'whatsapp_sender_id' => ['nullable', 'string', 'max:255'],
            'whatsapp_business_id' => ['nullable', 'string', 'max:255'],



            // General Settings
            'timezone' => ['nullable', 'string', 'max:255'],
            'currency' => ['nullable', 'string', 'max:10'],
            'date_format' => ['nullable', 'string', 'max:50'],
            'time_format' => ['nullable', 'string', 'max:50'],
            'language' => ['nullable', 'string', 'max:10'],

            // Interest/Late Fee Settings
            'late_fee_calculation_type' => ['nullable', 'in:none,percentage_daily,fixed_daily'],
            'late_fee_value' => ['nullable', 'numeric', 'min:0'],

            // Notification Settings
            'notify_bill_generated' => ['nullable', 'boolean'],
            'notify_payment_received' => ['nullable', 'boolean'],
            'notify_visitor_arrival' => ['nullable', 'boolean'],
            'notify_maintenance_request' => ['nullable', 'boolean'],
            'notify_announcement' => ['nullable', 'boolean'],

            // Feature Toggles
            'enable_visitor_management' => ['nullable', 'boolean'],
            'enable_maintenance_tickets' => ['nullable', 'boolean'],
            'enable_complaints' => ['nullable', 'boolean'],
            'enable_events' => ['nullable', 'boolean'],
            'enable_documents' => ['nullable', 'boolean'],
            'enable_directory' => ['nullable', 'boolean'],
            'enable_notices' => ['nullable', 'boolean'],
            'enable_polls' => ['nullable', 'boolean'],
            'enable_marketplace' => ['nullable', 'boolean'],
            'enable_facility_booking' => ['nullable', 'boolean'],

            // Security Settings
            'require_otp_for_login' => ['nullable', 'boolean'],
            'require_otp_for_payment' => ['nullable', 'boolean'],
            'session_timeout_minutes' => ['nullable', 'integer', 'min:5', 'max:1440'],
            'enable_2fa' => ['nullable', 'boolean'],


        ];
    }
}
