<?php

namespace App\Http\Requests\SocietyAdmin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateMaintenanceTicketRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $societyId = $this->route('society')->id;
        $ticketId = $this->route('maintenanceTicket')->id;

        return [
            'user_id' => ['required', 'exists:users,id', Rule::exists('users', 'id')->where('society_id', $societyId)],
            'ticket_no' => [
                'nullable',
                'string',
                'max:255',
                Rule::unique('maintenance_tickets', 'ticket_no')->ignore($ticketId),
            ],
            'title' => ['required', 'string', 'max:255'],
            'description' => ['required', 'string'],
            'priority' => ['required', 'in:low,medium,high,urgent'],
            'status' => ['nullable', 'in:open,assigned,in_progress,resolved,closed'],
            'vendor_id' => ['nullable', 'exists:users,id', Rule::exists('users', 'id')->where('society_id', $societyId)],
            'resolution_notes' => ['nullable', 'string'],
        ];
    }
}
