<?php

namespace App\Http\Requests\SocietyAdmin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateBankAccountRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $societyId = $this->route('society')->id;
        $bankAccountId = $this->route('bank_account')->id;

        return [
            'account_name' => ['required', 'string', 'max:255'],
            'account_number' => [
                'required',
                'string',
                'max:255',
                Rule::unique('bank_accounts', 'account_number')
                    ->where('society_id', $societyId)
                    ->ignore($bankAccountId),
            ],
            'ifsc_code' => ['required', 'string', 'max:11', 'min:11'],
            'bank_name' => ['required', 'string', 'max:255'],
            'branch_name' => ['nullable', 'string', 'max:255'],
            'balance' => ['nullable', 'numeric', 'min:0', 'max:999999999999.99'],
            'account_type' => ['required', 'in:savings,current,fd'],
            'is_primary' => ['boolean'],
            'description' => ['nullable', 'string'],
        ];
    }
}
