<?php

namespace App\Http\Requests\SocietyAdmin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateAnnouncementRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $societyId = $this->route('society')->id;

        return [
            'title' => ['required', 'string', 'max:255'],
            'content' => ['required', 'string'],
            'type' => ['required', 'in:info,urgent,event,maintenance,payment'],
            'priority' => ['required', 'in:normal,important,urgent'],
            'target_roles' => ['nullable', 'array'],
            'target_roles.*' => ['string', Rule::in(['resident', 'guard', 'vendor', 'staff'])],
            'target_buildings' => ['nullable', 'array'],
            'target_buildings.*' => ['integer', Rule::exists('buildings', 'id')->where('society_id', $societyId)],
            'target_units' => ['nullable', 'array'],
            'target_units.*' => ['integer', Rule::exists('units', 'id')->where('society_id', $societyId)],
            'start_date' => ['nullable', 'date'],
            'end_date' => ['nullable', 'date', 'after_or_equal:start_date'],
            'require_acknowledgement' => ['nullable', 'boolean'],
            'is_published' => ['nullable', 'boolean'],
        ];
    }
}
