<?php

namespace App\Http\Requests\SocietyAdmin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreUnitRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $societyId = $this->route('society')->id;

        return [
            'unit_no' => [
                'required',
                'string',
                'max:255',
                Rule::unique('units', 'unit_no')->where('society_id', $societyId),
            ],
            'building_id' => ['nullable', 'exists:buildings,id', Rule::exists('buildings', 'id')->where('society_id', $societyId)],
            'type' => ['required', 'in:apartment,shop,office,parking,flat,bungalow'],
            'area' => ['nullable', 'numeric', 'min:0', 'max:999999.99'],
            'status' => ['required', 'in:vacant,occupied,maintenance,rented'],
            'maintenance_structure_id' => ['nullable', 'exists:maintenance_structures,id', Rule::exists('maintenance_structures', 'id')->where('society_id', $societyId)],
        ];
    }

    /**
     * Prepare the data for validation.
     */
    protected function prepareForValidation(): void
    {
        if ($this->building_id === 'none') {
            $this->merge(['building_id' => null]);
        }

        if ($this->maintenance_structure_id === 'none') {
            $this->merge(['maintenance_structure_id' => null]);
        }
    }
}
