<?php

namespace App\Http\Requests\SocietyAdmin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreResidentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $societyId = $this->route('society')->id;

        return [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['nullable', 'email', 'max:255', Rule::unique('users', 'email')->where('society_id', $societyId)],
            'phone' => ['required', 'string', 'max:20', Rule::unique('users', 'phone')->where('society_id', $societyId)],
            'password' => ['required', 'string', 'min:8'],
            'unit_id' => ['nullable', 'exists:units,id', Rule::exists('units', 'id')->where('society_id', $societyId)],
            'status' => ['required', 'in:active,inactive,suspended'],
            'directory_visible' => ['boolean'],
        ];
    }
}
