<?php

namespace App\Http\Requests\SocietyAdmin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StorePaymentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $societyId = $this->route('society')->id;

        return [
            'bill_id' => ['nullable', 'exists:bills,id', Rule::exists('bills', 'id')->where('society_id', $societyId)],
            'bill_ids' => ['nullable', 'array'],
            'bill_ids.*' => ['exists:bills,id', Rule::exists('bills', 'id')->where('society_id', $societyId)],
            'user_id' => ['required', 'exists:users,id', Rule::exists('users', 'id')->where('society_id', $societyId)],
            'payment_no' => ['nullable', 'string', 'max:255', Rule::unique('payments', 'payment_no')],
            'amount' => ['required', 'numeric', 'min:0.01', 'max:999999.99'],
            'payment_method' => ['required', 'in:cash,cheque,online,bank_transfer'],
            'transaction_id' => ['nullable', 'string', 'max:255'],
            'status' => ['required', 'in:pending,completed,failed,pending_reconciliation'],
            'bank_account_id' => ['nullable', 'exists:bank_accounts,id', Rule::exists('bank_accounts', 'id')->where('society_id', $societyId)],
            'notes' => ['nullable', 'string'],
        ];
    }
}
