<?php

namespace App\Http\Requests\SocietyAdmin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreExpenseRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $societyId = $this->route('society')->id;

        return [
            'expense_no' => ['nullable', 'string', 'max:255', Rule::unique('expenses', 'expense_no')],
            'amount' => ['required', 'numeric', 'min:0.01', 'max:999999.99'],
            'gst_percentage' => ['nullable', 'numeric', 'min:0', 'max:100'],
            'gst_amount' => ['nullable', 'numeric', 'min:0', 'max:999999.99'],
            'total_amount' => ['nullable', 'numeric', 'min:0', 'max:999999.99'],
            'category' => ['nullable', 'string', 'max:255'],
            'description' => ['required', 'string'],
            'vendor_name' => ['nullable', 'string', 'max:255'],
            'vendor_id' => ['nullable', 'exists:users,id', Rule::exists('users', 'id')->where('society_id', $societyId)],
            'expense_date' => ['required', 'date'],
            'receipt_path' => ['nullable', 'string', 'max:255'],
            'bank_account_id' => ['nullable', 'exists:bank_accounts,id', Rule::exists('bank_accounts', 'id')->where('society_id', $societyId)],
        ];
    }
}
