<?php

namespace App\Http\Requests\SocietyAdmin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreBuildingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $societyId = $this->route('society')->id;

        return [
            'name' => ['required', 'string', 'max:255'],
            'building_no' => ['nullable', 'string', 'max:255', Rule::unique('buildings', 'building_no')->where('society_id', $societyId)],
            'floors' => ['required', 'integer', 'min:1', 'max:100'],
            'total_units' => ['nullable', 'integer', 'min:0'],
            'address' => ['nullable', 'string'],
        ];
    }
}
