<?php

namespace App\Http\Requests\SocietyAdmin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreBillRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $societyId = $this->route('society')->id;

        return [
            'bill_cycle_id' => ['nullable', 'exists:bill_cycles,id', Rule::exists('bill_cycles', 'id')->where('society_id', $societyId)],
            'user_id' => ['required', function ($attribute, $value, $fail) use ($societyId) {
                if ($value === 'all') return;
                if (!\App\Models\User::where('id', $value)->where('society_id', $societyId)->exists()) {
                    $fail('The selected resident is invalid.');
                }
            }],
            'bill_no' => ['nullable', 'string', 'max:255', Rule::unique('bills', 'bill_no')],
            'maintenance' => ['nullable', 'numeric', 'min:0', 'max:999999.99'],
            'water' => ['nullable', 'numeric', 'min:0', 'max:999999.99'],
            'electricity' => ['nullable', 'numeric', 'min:0', 'max:999999.99'],
            'parking' => ['nullable', 'numeric', 'min:0', 'max:999999.99'],
            'other_charges' => ['nullable', 'numeric', 'min:0', 'max:999999.99'],
            'gst' => ['nullable', 'numeric', 'min:0', 'max:999999.99'],
            'discount' => ['nullable', 'numeric', 'min:0', 'max:999999.99'],
            'status' => ['nullable', 'in:draft,under_review,pending,approved,due,paid,overdue,cancelled'],
            'due_date' => ['required', 'date'],
        ];
    }
}
