<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreCollectorPaymentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $user = auth()->guard('api')->user();
        $societyId = $user ? $user->society_id : null;

        return [
            'unit_id' => ['required', 'exists:units,id'],
            'bill_ids' => ['nullable', 'array'],
            'bill_ids.*' => ['exists:bills,id', Rule::exists('bills', 'id')->where('society_id', $societyId)],
            'bill_id' => ['nullable', 'exists:bills,id', Rule::exists('bills', 'id')->where('society_id', $societyId)], // Backward compatibility
            'amount' => ['required', 'numeric', 'min:0.01'],
            'payment_method' => ['required', 'in:cash,cheque,online,bank_transfer'],
            'transaction_id' => ['nullable', 'string', 'max:255'],
            'notes' => ['nullable', 'string', 'max:1000'],
            'receipt_photo' => ['nullable', 'string'], // Base64 encoded image
            'payment_date' => ['nullable', 'date'],
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'unit_id.required' => 'Unit ID is required.',
            'unit_id.exists' => 'The selected unit does not exist.',
            'amount.required' => 'Payment amount is required.',
            'amount.numeric' => 'Payment amount must be a number.',
            'amount.min' => 'Payment amount must be at least 0.01.',
            'payment_method.required' => 'Payment method is required.',
            'payment_method.in' => 'Invalid payment method.',
        ];
    }
}
