<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RoleMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     * @param  string  ...$roles  One or more roles allowed to access
     */
    public function handle(Request $request, Closure $next, string ...$roles): Response
    {
        $guard = $request->is('api/*') ? 'api' : 'web';
        $user = Auth::guard($guard)->user();

        if (! $user) {
            if ($request->is('api/*')) {
                return response()->json(['message' => 'Unauthenticated'], 401);
            }
            return redirect()->route('login');
        }

        // Ensure role relationship is loaded
        $user->loadMissing('role');

        $userRoleName = $user->role?->name;

        if (! $userRoleName || ! in_array($userRoleName, $roles)) {
            $rolesString = implode(', ', $roles);
            if ($request->is('api/*')) {
                return response()->json(['message' => "Access denied. Required roles: {$rolesString}"], 403);
            }
            abort(403, "Access denied. Required roles: {$rolesString}");
        }

        // Set user context for views (only for web requests)
        if (! $request->is('api/*')) {
            session(['user_role' => $userRoleName]);
        }

        return $next($request);
    }
}
