<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureSocietyAccess
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = auth()->user();

        if (! $user) {
            abort(403, 'Unauthorized access.');
        }

        $society = $request->route('society');

        // Handle route model binding - society could be a model instance or ID
        $societyId = $society instanceof \App\Models\Society
            ? $society->id
            : (int) $society;

        if ($user->society_id !== $societyId) {
            abort(403, 'Unauthorized access to this society.');
        }

        return $next($request);
    }
}
