<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureFeatureEnabled
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, string $feature): Response
    {
        $user = $request->user();

        if (! $user || ! $user->society) {
            // If no user or society, maybe allow? Or block?
            // Usually this middleware is applied to authenticated routes with society context.
            // Let's assume if no society, we can't check feature, so maybe block or skip?
            // For safety, let's block if it's a critical feature.
            abort(403, 'Society context missing.');
        }

        if ($user->role?->name === 'super_admin') {
            return $next($request);
        }

        if (! $user->society->hasFeature($feature)) {
            abort(403, 'This feature is not available in your current subscription plan.');
        }

        return $next($request);
    }
}
