<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Symfony\Component\HttpFoundation\Response;

class CheckInstallation
{
    /**
     * Handle an incoming request.
     *
     * Check if the application is installed. If not, redirect to the installation wizard.
     * If installed, block access to installation routes.
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Direct file check - most reliable method
        $installedFile = storage_path('app/private/installed.json');
        $isInstalled = file_exists($installedFile);

        // Check if current route is an install route
        $path = $request->path();
        $isInstallRoute = str_starts_with($path, 'install') || $request->is('install*');

        // Use file sessions during installation (before migrations create sessions table)
        if ($isInstallRoute && config('session.driver') === 'database') {
            config(['session.driver' => 'file']);
        }

        // If not installed and not on install route, redirect to install
        if (!$isInstalled && !$isInstallRoute) {
            return redirect('/install');
        }

        // If installed and trying to access install route, redirect away
        if ($isInstalled && $isInstallRoute) {
            return redirect()->route('super-admin.login');
        }

        return $next($request);
    }
}
