<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckBillOverdueStatus
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Check for society parameter
        $society = $request->route('society');
        $societyId = null;

        if ($society instanceof \App\Models\Society) {
            $societyId = $society->id;
        } elseif (is_numeric($society)) {
            $societyId = $society;
        }

        if ($societyId) {
            // 1. Mark Overdue Bills
            \App\Models\Bill::where('society_id', $societyId)
                ->whereIn('status', ['due', 'approved'])
                ->where('due_date', '<', now()->format('Y-m-d'))
                ->update(['status' => 'overdue']);

            // 2. Mark Paid Bills (Safety check)
            // Note: whereRaw() is safe here as it uses hardcoded column names and status values
            // No user input is directly interpolated into the query
            \App\Models\Bill::where('society_id', $societyId)
                ->where('status', '!=', 'paid')
                ->whereRaw('(SELECT COALESCE(SUM(amount), 0) FROM payments WHERE payments.bill_id = bills.id AND payments.status = ? AND payments.deleted_at IS NULL) >= bills.amount', ['completed'])
                ->update(['status' => 'paid', 'paid_at' => now()]);
        }
        
        return $next($request);
    }
}
