<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class WelcomeController extends Controller
{
    public function index()
    {
        $cmsSettings = [
            'hero_title' => \App\Models\SystemSetting::getValue('hero_title', 'Smart Society Management Platform'),
            'hero_subtitle' => \App\Models\SystemSetting::getValue('hero_subtitle', 'The #1 SaaS-based operating system for modern housing societies.'),
            'hero_badge' => \App\Models\SystemSetting::getValue('hero_badge', 'Trusted by 500+ societies'),
            'enable_features_section' => \App\Models\SystemSetting::getValue('enable_features_section', '1') === '1',
            'enable_testimonials_section' => \App\Models\SystemSetting::getValue('enable_testimonials_section', '1') === '1',
            'enable_faq_section' => \App\Models\SystemSetting::getValue('enable_faq_section', '1') === '1',
            'enable_cta_section' => \App\Models\SystemSetting::getValue('enable_cta_section', '1') === '1',
        ];

        return \Inertia\Inertia::render('Welcome', [
            'canRegister' => \Laravel\Fortify\Features::enabled(\Laravel\Fortify\Features::registration()),
            'features' => \App\Models\CmsFeature::where('is_active', true)->orderBy('sort_order')->get(),
            'faqs' => \App\Models\CmsFaq::where('is_active', true)->orderBy('sort_order')->get(),
            'testimonials' => \App\Models\CmsTestimonial::where('is_active', true)->orderBy('sort_order')->get(),
            'cmsSettings' => $cmsSettings,
        ]);
    }
}
