<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CmsTestimonialController extends Controller
{
    public function index()
    {
        return \Inertia\Inertia::render('SuperAdmin/Cms/Testimonials/Index', [
            'testimonials' => \App\Models\CmsTestimonial::orderBy('sort_order')->get()
        ]);
    }

    public function create()
    {
        return \Inertia\Inertia::render('SuperAdmin/Cms/Testimonials/Create');
    }

    public function store(\Illuminate\Http\Request $request)
    {
        $validated = $request->validate([
            'author' => 'required|string|max:255',
            'role' => 'nullable|string|max:255',
            'quote' => 'required|string',
            'image' => 'nullable|string',
            'rating' => 'integer|min:1|max:5',
            'sort_order' => 'integer|min:0',
            'is_active' => 'boolean'
        ]);

        \App\Models\CmsTestimonial::create($validated);

        return redirect()->route('super-admin.cms.testimonials.index')
            ->with('success', 'Testimonial created successfully.');
    }

    public function edit($id)
    {
        $testimonial = \App\Models\CmsTestimonial::findOrFail($id);
        return \Inertia\Inertia::render('SuperAdmin/Cms/Testimonials/Edit', [
            'testimonial' => $testimonial
        ]);
    }

    public function update(\Illuminate\Http\Request $request, $id)
    {
        $testimonial = \App\Models\CmsTestimonial::findOrFail($id);
        
        $validated = $request->validate([
            'author' => 'required|string|max:255',
            'role' => 'nullable|string|max:255',
            'quote' => 'required|string',
            'image' => 'nullable|string',
            'rating' => 'integer|min:1|max:5',
            'sort_order' => 'integer|min:0',
            'is_active' => 'boolean'
        ]);

        $testimonial->update($validated);

        return redirect()->route('super-admin.cms.testimonials.index')
            ->with('success', 'Testimonial updated successfully.');
    }

    public function destroy($id)
    {
        $testimonial = \App\Models\CmsTestimonial::findOrFail($id);
        $testimonial->delete();

        return redirect()->route('super-admin.cms.testimonials.index')
            ->with('success', 'Testimonial deleted successfully.');
    }
}
