<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CmsFeatureController extends Controller
{
    public function index()
    {
        return \Inertia\Inertia::render('SuperAdmin/Cms/Features/Index', [
            'features' => \App\Models\CmsFeature::orderBy('sort_order')->get()
        ]);
    }

    public function create()
    {
        return \Inertia\Inertia::render('SuperAdmin/Cms/Features/Create');
    }

    public function store(\Illuminate\Http\Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'required|string',
            'icon' => 'nullable|string|max:50',
            'sort_order' => 'integer|min:0',
            'is_active' => 'boolean'
        ]);

        \App\Models\CmsFeature::create($validated);

        return redirect()->route('super-admin.cms.features.index')
            ->with('success', 'Feature created successfully.');
    }

    public function edit($id)
    {
        $feature = \App\Models\CmsFeature::findOrFail($id);
        return \Inertia\Inertia::render('SuperAdmin/Cms/Features/Edit', [
            'feature' => $feature
        ]);
    }

    public function update(\Illuminate\Http\Request $request, $id)
    {
        $feature = \App\Models\CmsFeature::findOrFail($id);
        
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'required|string',
            'icon' => 'nullable|string|max:50',
            'sort_order' => 'integer|min:0',
            'is_active' => 'boolean'
        ]);

        $feature->update($validated);

        return redirect()->route('super-admin.cms.features.index')
            ->with('success', 'Feature updated successfully.');
    }

    public function destroy($id)
    {
        $feature = \App\Models\CmsFeature::findOrFail($id);
        $feature->delete();

        return redirect()->route('super-admin.cms.features.index')
            ->with('success', 'Feature deleted successfully.');
    }
}
