<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CmsFaqController extends Controller
{
    public function index()
    {
        return \Inertia\Inertia::render('SuperAdmin/Cms/Faqs/Index', [
            'faqs' => \App\Models\CmsFaq::orderBy('sort_order')->get()
        ]);
    }

    public function create()
    {
        return \Inertia\Inertia::render('SuperAdmin/Cms/Faqs/Create');
    }

    public function store(\Illuminate\Http\Request $request)
    {
        $validated = $request->validate([
            'question' => 'required|string|max:255',
            'answer' => 'required|string',
            'sort_order' => 'integer|min:0',
            'is_active' => 'boolean'
        ]);

        \App\Models\CmsFaq::create($validated);

        return redirect()->route('super-admin.cms.faqs.index')
            ->with('success', 'FAQ created successfully.');
    }

    public function edit($id)
    {
        $faq = \App\Models\CmsFaq::findOrFail($id);
        return \Inertia\Inertia::render('SuperAdmin/Cms/Faqs/Edit', [
            'faq' => $faq
        ]);
    }

    public function update(\Illuminate\Http\Request $request, $id)
    {
        $faq = \App\Models\CmsFaq::findOrFail($id);
        
        $validated = $request->validate([
            'question' => 'required|string|max:255',
            'answer' => 'required|string',
            'sort_order' => 'integer|min:0',
            'is_active' => 'boolean'
        ]);

        $faq->update($validated);

        return redirect()->route('super-admin.cms.faqs.index')
            ->with('success', 'FAQ updated successfully.');
    }

    public function destroy($id)
    {
        $faq = \App\Models\CmsFaq::findOrFail($id);
        $faq->delete();

        return redirect()->route('super-admin.cms.faqs.index')
            ->with('success', 'FAQ deleted successfully.');
    }
}
