<?php

namespace App\Http\Controllers\SuperAdmin\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Inertia\Inertia;
use Inertia\Response;

class AuthenticatedSessionController extends Controller
{
    /**
     * Show the login form.
     */
    public function create(): Response
    {
        return Inertia::render('SuperAdmin/Auth/Login', [
            'demoMode' => config('app.demo_mode'),
            'demoCredentials' => config('app.demo_mode') ? config('app.demo_credentials.super_admin') : null,
        ]);
    }

    /**
     * Handle an incoming authentication request.
     */
    public function store(Request $request): RedirectResponse
    {
        $request->validate([
            'email' => ['required', 'string', 'email'],
            'password' => ['required', 'string'],
        ]);

        if (! Auth::guard('super_admin')->attempt($request->only('email', 'password'), $request->boolean('remember'))) {
            // Show error message
            return $this->redirectWithError('Invalid credentials. Please try again.');
        }

        $request->session()->regenerate();

        // Show success message - methods available automatically!
        return $this->redirectToWithSuccess('super-admin.dashboard', 'Welcome back, Super Admin!');
    }

    /**
     * Destroy an authenticated session.
     */
    public function destroy(Request $request): RedirectResponse
    {
        Auth::guard('super_admin')->logout();

        $request->session()->invalidate();
        $request->session()->regenerateToken();

        // Show info message on logout
        return redirect()->route('super-admin.login')->with('info', 'You have been logged out successfully');
    }
}
