<?php

namespace App\Http\Controllers\SocietyAdmin;

use App\Http\Controllers\Controller;
use App\Models\Society;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Auth;
use Inertia\Inertia;
use Inertia\Response;

class SocietyAccessController extends Controller
{
    /**
     * Redirect society admin to their society dashboard
     */
    public function redirectToSociety(): RedirectResponse
    {
        $user = Auth::user();

        if (! $user || ! $user->society_id) {
            return redirect()->route('dashboard')
                ->with('error', 'No society assigned to your account.');
        }

        $society = Society::find($user->society_id);

        if (! $society) {
            return redirect()->route('dashboard')
                ->with('error', 'Society not found.');
        }

        // Redirect to society-specific dashboard
        // This route will be created when Society Admin module is built
        return redirect()->route('society.dashboard', ['society' => $society->id]);
    }

    /**
     * Show society admin dashboard
     */
    public function dashboard(Society $society): Response
    {
        // Verify user has access to this society
        $user = Auth::user();

        if ($user->society_id !== $society->id) {
            abort(403, 'You do not have access to this society.');
        }

        $society->load(['users.role', 'platformFee']);

        return Inertia::render('SocietyAdmin/Dashboard', [
            'society' => $society,
        ]);
    }
}
