<?php

namespace App\Http\Controllers\SocietyAdmin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class MaintenanceStructureController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(\Illuminate\Http\Request $request, \App\Models\Society $society)
    {
        $user = \Illuminate\Support\Facades\Auth::user();

        if ($user->society_id !== $society->id) {
            abort(403, 'Unauthorized access to this society.');
        }

        $structures = \App\Models\MaintenanceStructure::where('society_id', $society->id)
            ->latest()
            ->paginate(10);

        return \Inertia\Inertia::render('SocietyAdmin/MaintenanceStructures/Index', [
            'society' => $society->only([
                'id', 'name', 'code', 'address', 'city', 'state', 'pincode', 
                'phone', 'email', 'gst_no', 'registration_no', 'logo'
            ]),
            'structures' => $structures,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(\Illuminate\Http\Request $request, \App\Models\Society $society)
    {
        $user = \Illuminate\Support\Facades\Auth::user();

        if ($user->society_id !== $society->id) {
            abort(403, 'Unauthorized access to this society.');
        }

        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'maintenance' => 'required|numeric|min:0',
            'parking' => 'required|numeric|min:0',
            'other_charges' => 'required|numeric|min:0',
            'description' => 'nullable|string',
        ]);

        $society->maintenanceStructures()->create($validated);

        return redirect()->back()->with('success', 'Maintenance structure created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(\Illuminate\Http\Request $request, \App\Models\Society $society, \App\Models\MaintenanceStructure $maintenanceStructure)
    {
        $user = \Illuminate\Support\Facades\Auth::user();

        if ($user->society_id !== $society->id || $maintenanceStructure->society_id !== $society->id) {
            abort(403, 'Unauthorized access.');
        }

        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'maintenance' => 'required|numeric|min:0',
            'parking' => 'required|numeric|min:0',
            'other_charges' => 'required|numeric|min:0',
            'description' => 'nullable|string',
        ]);

        $maintenanceStructure->update($validated);

        return redirect()->back()->with('success', 'Maintenance structure updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(\App\Models\Society $society, \App\Models\MaintenanceStructure $maintenanceStructure)
    {
        $user = \Illuminate\Support\Facades\Auth::user();

        if ($user->society_id !== $society->id || $maintenanceStructure->society_id !== $society->id) {
            abort(403, 'Unauthorized access.');
        }

        $maintenanceStructure->delete();

        return redirect()->back()->with('success', 'Maintenance structure deleted successfully.');
    }
}
