<?php

namespace App\Http\Controllers\SocietyAdmin;

use App\Http\Controllers\Controller;
use App\Models\CommunityPost;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Illuminate\Support\Facades\Auth;

class CommunityPostController extends Controller
{
    public function index(Request $request)
    {
        $user = Auth::user();
        
        $posts = CommunityPost::where('society_id', $user->society_id)
            ->with(['user', 'group']) 
            ->withCount(['likes', 'comments'])
            ->orderBy('created_at', 'desc')
            ->paginate(10);

        return Inertia::render('SocietyAdmin/Community/Index', [
            'society' => $user->society,
            'posts' => $posts,
        ]);
    }

    public function destroy(CommunityPost $communityPost)
    {
        if (Auth::user()->society_id !== $communityPost->society_id) {
             abort(403);
        }
        
        $communityPost->delete();

        return redirect()->back()->with('success', 'Post deleted successfully.');
    }
}
