<?php

namespace App\Http\Controllers\SocietyAdmin;

use App\Http\Controllers\Controller;
use App\Models\AdSlot;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inertia\Inertia;

class AdminAdSettingsController extends Controller
{
    public function index()
    {
        // Ensure slots exist for this society. If not, seed them.
        $positions = ['app_open_popup', 'community_top', 'community_bottom'];
        foreach ($positions as $position) {
            AdSlot::firstOrCreate(
                ['society_id' => Auth::user()->society_id, 'position' => $position],
                [
                    'name' => ucwords(str_replace('_', ' ', $position)), 
                    'price_per_day' => 100, 
                    'max_concurrent_ads' => 5, 
                    'status' => true
                ]
            );
        }

        $slots = AdSlot::where('society_id', Auth::user()->society_id)->get();
        
        return Inertia::render('SocietyAdmin/Monetization/Settings', [
            'slots' => $slots,
            'society' => Auth::user()->society,
        ]);
    }

    public function update(Request $request)
    {
        $data = $request->validate([
            'slots' => 'required|array',
            'slots.*.id' => 'required|exists:ad_slots,id',
            'slots.*.price_per_day' => 'required|numeric|min:0',
            'slots.*.max_concurrent_ads' => 'required|integer|min:1',
            'slots.*.status' => 'required|boolean',
        ]);

        foreach ($data['slots'] as $slotData) {
            AdSlot::where('id', $slotData['id'])
                ->where('society_id', Auth::user()->society_id)
                ->update([
                    'price_per_day' => $slotData['price_per_day'],
                    'max_concurrent_ads' => $slotData['max_concurrent_ads'],
                    'status' => $slotData['status'],
                ]);
        }
        
        return redirect()->back()->with('success', 'Settings updated successfully.');
    }
}
