<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class FcmTokenController extends Controller
{
    /**
     * Update FCM token for authenticated mobile user
     */
    public function updateToken(Request $request): JsonResponse
    {
        $request->validate([
            'fcm_token' => ['required', 'string', 'max:200'],
        ]);

        $user = $request->user(); // From sanctum (mobile user)

        // Validate mobile role only
        if (! $user->isMobileUser()) {
            return response()->json(['error' => 'FCM tokens only for mobile users'], 403);
        }

        $user->update([
            'fcm_token' => $request->fcm_token,
        ]);

        return response()->json([
            'message' => 'FCM token updated successfully',
            'user' => [
                'id' => $user->id,
                'name' => $user->name,
                'role' => $user->role->name,
                'fcm_token' => $user->fcm_token,
            ],
        ]);
    }
}
