<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class LinkOrphanedPayments extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:link-orphaned-payments';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $payments = \App\Models\Payment::whereNull('bill_id')->get();
        $count = 0;

        foreach ($payments as $payment) {
            // Find a matching bill: same user, same amount, not already paid (or linked to another payment ideally, but status check is easier)
            // We look for 'due' or 'overdue' or 'approved' bills. 
            // We should imply avoiding bills that are already paid, though if the system is out of sync they might be 'paid' without link? 
            // Unlikely. Assuming status is NOT 'paid'.
            $bill = \App\Models\Bill::where('user_id', $payment->user_id)
                ->where('amount', $payment->amount)
                ->where('status', '!=', 'paid')
                ->first();

            if ($bill) {
                // Link Payment
                $payment->update(['bill_id' => $bill->id]);

                // Update Bill Status if payment is completed
                if ($payment->status === 'completed') {
                    $bill->update([
                        'status' => 'paid', 
                        'paid_at' => $payment->created_at
                    ]);
                }
                
                $this->info("Linked Payment #{$payment->payment_no} to Bill #{$bill->bill_no}");
                $count++;
            }
        }

        $this->info("Successfully linked {$count} orphaned payments.");
    }
}
