# Societify - Complete Society Management System

A comprehensive, modern society management system designed to streamline operations for residential complexes, housing societies, and gated communities.

## Features

- **Multi-Tenancy SaaS**: Manage unlimited societies from a single Super Admin dashboard
- **Automated Billing**: Generate recurring maintenance invoices with penalty logic
- **Visitor Management**: QR code-based entry system for guests
- **Facility Booking**: Schedule amenities like clubhouses and pools
- **Helpdesk System**: Track complaints from opened to resolved
- **Mobile Applications**: Flutter-based iOS and Android apps
- **Payment Gateways**: Integrated PayPal, Stripe, Razorpay, and more
- **Role-Based Access**: Super Admin, Society Admin, Sub Admin, and Accountant roles
- **Financial Reports**: Comprehensive revenue and expense tracking
- **Document Cloud**: Centralized repository for meeting minutes and circulars
- **Community Features**: Social posts, groups, and engagement tools
- **Emergency Alerts**: Real-time emergency notification system
- **Advertisement Management**: Manage ad slots and revenue

## Offline documentation

See `docs/README.md`.

## Requirements

- PHP 8.2 or higher
- MySQL 5.7+ / PostgreSQL 12+ / SQLite 3.8+
- Composer 2.0+
- Node.js 18+ and NPM
- Web server (Apache/Nginx)
- SSL Certificate (recommended for production)

## Installation

### Quick Start (Recommended)

**The easiest way to install Societify is using the built-in installation wizard:**

1. **Extract Files**: Extract all files to your web server directory
2. **Set Permissions**: Ensure write permissions on `storage` and `bootstrap/cache` directories
3. **Access Installation Wizard**: Navigate to `http://your-domain.com/install` in your browser
4. **Follow the Wizard**: The installation wizard will guide you through:
   - System requirements check
   - Database configuration (SQLite or MySQL)
   - Super Admin account creation
   - Final setup

The installation wizard automatically:
- Checks PHP version and required extensions
- Validates file permissions
- Configures database connection
- Runs migrations
- Creates necessary seeders
- Sets up storage links

### Manual Installation

If you prefer manual installation:

#### Step 1: Extract Files
Extract the files to your web server directory. Ensure the web server has write permissions to the `storage` and `bootstrap/cache` directories.

#### Step 2: Install Dependencies
```bash
# Install PHP dependencies
composer install --no-dev --optimize-autoloader

# Install frontend dependencies
npm install
```

#### Step 3: Environment Configuration
```bash
# Copy environment file
cp .env.example .env

# Generate application key
php artisan key:generate
```

#### Step 4: Configure Environment
Edit the `.env` file and configure:
- Database connection settings (SQLite is default, MySQL/PostgreSQL supported)
- Mail configuration
- Payment gateway credentials (optional)
- SMS/WhatsApp gateway settings (optional)
- Firebase credentials for push notifications (optional)

#### Step 5: Database Setup
```bash
# Run migrations
php artisan migrate --force

# Seed initial data (optional, for demo purposes)
php artisan db:seed --force
```

#### Step 6: Build Frontend Assets
```bash
# Production build
npm run build

# Or for development
npm run dev
```

**Important for Production Servers:**
If you're building assets on a production server and the web server user is different from the user running the build command, you may need to fix ownership after building:

```bash
# Fix ownership of build directory (replace with your actual web server user)
sudo chown -R uniquedeveloper-societify:uniquedeveloper-societify public/build
```

**Recommended:** Build assets as the web server user to avoid ownership issues:
```bash
# Switch to web server user first
sudo su - uniquedeveloper-societify

# Then run the build
cd /path/to/project
npm run build
```

#### Step 7: Storage Link
```bash
# Create symbolic link for public storage
php artisan storage:link
```

#### Step 8: Web Server Configuration
Configure your web server to point to the `public` directory as the document root.

**Apache Example:**
```apache
<VirtualHost *:80>
    ServerName your-domain.com
    DocumentRoot /path-to-project/public
    
    <Directory /path-to-project/public>
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

**Nginx Example:**
```nginx
server {
    listen 80;
    server_name your-domain.com;
    root /path-to-project/public;
    
    index index.php;
    
    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }
    
    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.2-fpm.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $realpath_root$fastcgi_script_name;
        include fastcgi_params;
    }
}
```

### Step 9: Cron Job Setup
Set up a cron job to run Laravel's scheduler:
```bash
* * * * * cd /path-to-your-project && php artisan schedule:run >> /dev/null 2>&1
```

## Configuration

### Database Configuration

**SQLite (Default - Recommended for Quick Setup):**
```env
DB_CONNECTION=sqlite
DB_DATABASE=database/database.sqlite
```
The SQLite database file will be created automatically in the `database` directory.

**MySQL/PostgreSQL:**
```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=your_database
DB_USERNAME=your_username
DB_PASSWORD=your_password
```

### Mail Configuration
Configure your mail settings for notifications:
```env
MAIL_MAILER=smtp
MAIL_HOST=smtp.mailtrap.io
MAIL_PORT=2525
MAIL_USERNAME=your_username
MAIL_PASSWORD=your_password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=noreply@example.com
MAIL_FROM_NAME="${APP_NAME}"
```

### Payment Gateways (Database-driven)
Payment gateway credentials are **database-driven**:
- **Society payments** (bills/facilities): configure per-society under **Society Admin → Settings → Payment**
- **SaaS subscription payments**: configure under **Super Admin → Settings → Payments**

Do **not** put Razorpay keys in `.env`.

### Firebase (Push Notifications)
For mobile app push notifications:
```env
FIREBASE_PROJECT_ID=your_project_id
FIREBASE_CREDENTIALS=/path/to/firebase-credentials.json
```

## Default Login Credentials

After running seeders, you can use these credentials (all passwords are `password`):

**Super Admin:**
- Email: `admin@societify.com`
- Password: `password`
- *Created by: SuperAdminSeeder*

**Society Admin:**
- Email: `societyadmin@societify.com`
- Password: `password`
- Phone: `9876543210`
- *Created by: UserSeeder*

**Sub Admin:**
- Email: `subadmin@societify.com`
- Password: `password`
- Phone: `9876543211`
- *Created by: UserSeeder*

**Accountant:**
- Email: `accountant@societify.com`
- Password: `password`
- Phone: `9876543212`
- *Created by: UserSeeder*

**Additional Demo Users (Mobile App):**
- Resident: Phone `9876543213`, Password: `password`
- Security Guard: Phone `9876543214`, Password: `password`

⚠️ **Important**: Change all default passwords immediately after installation!

## Mobile App Setup

1. Navigate to the mobile app directory (if included)
2. Run `flutter pub get` to install dependencies
3. Update API base URL in configuration files
4. Configure Firebase for push notifications
5. Build for iOS: `flutter build ios`
6. Build for Android: `flutter build apk`

## Troubleshooting

### Permission Issues
```bash
# Set proper permissions
chmod -R 755 storage bootstrap/cache
chown -R www-data:www-data storage bootstrap/cache
```

### Clear Cache
```bash
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
```

### Database Issues
If you encounter migration issues:
```bash
php artisan migrate:fresh --force
php artisan db:seed --force
```

**For SQLite users:**
- Ensure the `database` directory is writable
- The `database.sqlite` file will be created automatically
- If the file exists but is empty, delete it and run migrations again

### Frontend Not Loading
Ensure you've built the frontend assets:
```bash
npm run build
```

**If assets are built but still not loading:**
- Check file ownership: The `public/build` directory should be owned by your web server user
- Fix ownership if needed: `sudo chown -R your-web-server-user:your-web-server-user public/build`
- Clear Laravel caches: `php artisan view:clear && php artisan cache:clear`
- Verify manifest file exists: `ls -la public/build/manifest.json`

## Security Considerations

- Change all default passwords immediately
- Use strong database passwords
- Enable HTTPS in production
- Keep dependencies updated
- Regularly backup your database
- Review and configure file upload limits
- Set appropriate file permissions

## Support

- **Live Demo**: https://uniquify.uniquedeveloper.in/
- **Documentation**: https://uniquedevlopers.github.io/societify-docs/
- **Support Contact**: https://api.whatsapp.com/message/NSAUJ5OHCRA6L1

## License

This is a commercial item. Please refer to the license file for details.

## Changelog

See [CHANGELOG.md](CHANGELOG.md) for version history and updates.

## Credits

Built with:
- Laravel 12
- React 19
- Inertia.js v2
- Tailwind CSS v4
- TypeScript

